/*
 * Decompiled with CFR 0.152.
 */
package lykrast.defiledlands.common.entity.passive;

import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import lykrast.defiledlands.common.entity.IEntityDefiled;
import lykrast.defiledlands.common.init.ModBlocks;
import lykrast.defiledlands.common.init.ModItems;
import lykrast.defiledlands.common.init.ModSounds;
import lykrast.defiledlands.common.util.Config;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityBookWyrm
extends EntityAnimal
implements IEntityDefiled,
IEntityAdditionalSpawnData {
    public static final ResourceLocation LOOT = new ResourceLocation("defiledlands", "entities/bookwyrm/normal");
    public static final ResourceLocation LOOT_GOLDEN = new ResourceLocation("defiledlands", "entities/bookwyrm/golden");
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.field_151134_bR, ModItems.foulCandy});
    private static final DataParameter<Boolean> GOLDEN = EntityDataManager.func_187226_a(EntityBookWyrm.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DIGEST_TIME = EntityDataManager.func_187226_a(EntityBookWyrm.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> MAX_LEVEL = EntityDataManager.func_187226_a(EntityBookWyrm.class, (DataSerializer)DataSerializers.field_187192_b);
    public int digested;
    public int digesting;
    public int digestTimer;

    public EntityBookWyrm(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 0.9f);
        this.field_175506_bl = ModBlocks.grassDefiled;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GOLDEN, (Object)false);
        this.field_70180_af.func_187214_a(DIGEST_TIME, (Object)200);
        this.field_70180_af.func_187214_a(MAX_LEVEL, (Object)3);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPanic(1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.2, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIHurtByTarget());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.26);
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 5.0f);
    }

    protected void func_70619_bc() {
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            if (this.func_70638_az() != null) {
                this.func_70624_b(null);
            }
            if (this.func_70643_av() != null) {
                this.func_70604_c(null);
            }
        }
        super.func_70619_bc();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.digesting > 0 && this.digestTimer > 0) {
            --this.digestTimer;
            if (this.field_70170_p.field_72995_K) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.ENCHANTMENT_TABLE, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.25 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
            if (this.digestTimer <= 0) {
                ++this.digested;
                --this.digesting;
                this.playDigestEffect(false);
                if (this.digesting > 0) {
                    this.digestTimer = this.getDigestTime();
                }
            }
        }
        if (this.digested >= this.getMaxLevel()) {
            List list;
            this.digested -= this.getMaxLevel();
            this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_184185_a(SoundEvents.field_187802_ec, 1.0f, 1.0f);
            this.playDigestEffect(true);
            if (!this.field_70170_p.field_72995_K && !(list = EnchantmentHelper.func_77513_b((Random)this.field_70146_Z, (ItemStack)new ItemStack(Items.field_151122_aG), (int)this.getMaxLevel(), (boolean)this.isGolden())).isEmpty()) {
                Collections.sort(list, Comparator.comparingInt(e -> -e.field_76302_b.func_77321_a(e.field_76303_c)));
                int remaining = (int)((float)this.getMaxLevel() / Config.conversionRate);
                for (EnchantmentData e2 : list) {
                    int value = (int)((float)e2.field_76302_b.func_77321_a(e2.field_76303_c) * Config.conversionRate);
                    if (remaining < value) continue;
                    ItemStack book = new ItemStack(Items.field_151134_bR);
                    ItemEnchantedBook.func_92115_a((ItemStack)book, (EnchantmentData)e2);
                    this.func_70099_a(book, 0.5f);
                    if ((remaining -= value) > 0) continue;
                    break;
                }
            }
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!super.func_184645_a(player, hand)) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (itemstack.func_77973_b() == Items.field_151134_bR && !this.func_70631_g_()) {
                Map list = EnchantmentHelper.func_82781_a((ItemStack)itemstack);
                if (list.isEmpty()) {
                    return false;
                }
                int i = 0;
                for (Map.Entry e : list.entrySet()) {
                    i += ((Enchantment)e.getKey()).func_77321_a(((Integer)e.getValue()).intValue());
                }
                if ((i = (int)((float)i * Config.conversionRate)) > 0) {
                    this.digesting += i;
                    if (this.digestTimer == 0) {
                        this.digestTimer = this.getDigestTime();
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                    this.func_184185_a(SoundEvents.field_187739_dZ, 1.0f, this.field_70146_Z.nextFloat() * 0.1f + 0.9f);
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    protected void playDigestEffect(boolean success) {
        if (!this.field_70170_p.field_72995_K) {
            return;
        }
        EnumParticleTypes enumparticletypes = EnumParticleTypes.SMOKE_NORMAL;
        if (success) {
            enumparticletypes = EnumParticleTypes.VILLAGER_HAPPY;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.setGolden(this.field_70170_p.field_73012_v.nextInt(100) == 0);
        this.setDigestTime(MathHelper.func_76136_a((Random)this.field_70146_Z, (int)160, (int)240));
        this.setMaxLevel(MathHelper.func_76136_a((Random)this.field_70146_Z, (int)3, (int)6));
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70873_a(-24000);
        }
        return livingdata;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityBookWyrm child = new EntityBookWyrm(this.field_70170_p);
        if (ageable instanceof EntityBookWyrm) {
            this.setOffspringAttributes((EntityBookWyrm)ageable, child);
        }
        return child;
    }

    protected void setOffspringAttributes(EntityBookWyrm parent, EntityBookWyrm child) {
        boolean flag1 = this.isGolden();
        boolean flag2 = parent.isGolden();
        if (flag1 || flag2) {
            int i = 25;
            if (flag1 && flag2) {
                i = 10;
            }
            child.setGolden(this.field_70146_Z.nextInt(i) == 0);
        } else {
            child.setGolden(this.field_70146_Z.nextInt(100) == 0);
        }
        int j1 = this.getDigestTime();
        int j2 = parent.getDigestTime();
        int k = j1 + j2 - this.field_70146_Z.nextInt((int)((double)Math.max(j1, j2) + 0.75));
        child.setDigestTime(k / 2);
        j1 = this.getMaxLevel();
        j2 = parent.getMaxLevel();
        k = j1 + j2 + this.field_70146_Z.nextInt(Math.max(j1, j2) + 1);
        child.setMaxLevel(Math.min(k / 2, 30));
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Golden", this.isGolden());
        compound.func_74768_a("Digest", this.getDigestTime());
        compound.func_74768_a("MaxLvl", this.getMaxLevel());
        compound.func_74768_a("Digested", this.digested);
        compound.func_74768_a("Digesting", this.digesting);
        compound.func_74768_a("DigestTimer", this.digestTimer);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setGolden(compound.func_74767_n("Golden"));
        this.setDigestTime(compound.func_74762_e("Digest"));
        this.setMaxLevel(compound.func_74762_e("MaxLvl"));
        this.digested = compound.func_74762_e("Digested");
        this.digesting = compound.func_74762_e("Digesting");
        this.digestTimer = compound.func_74762_e("DigestTimer");
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.digested);
        buffer.writeInt(this.digesting);
        buffer.writeInt(this.digestTimer);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.digested = additionalData.readInt();
        this.digesting = additionalData.readInt();
        this.digestTimer = additionalData.readInt();
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.bookWyrmIdle;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return ModSounds.bookWyrmHurt;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.bookWyrmDeath;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    public boolean isGolden() {
        return (Boolean)this.field_70180_af.func_187225_a(GOLDEN);
    }

    public void setGolden(boolean golden) {
        this.field_70180_af.func_187227_b(GOLDEN, (Object)golden);
    }

    public int getDigestTime() {
        return (Integer)this.field_70180_af.func_187225_a(DIGEST_TIME);
    }

    public void setDigestTime(int digest) {
        this.field_70180_af.func_187227_b(DIGEST_TIME, (Object)Math.max(digest, 1));
    }

    public int getMaxLevel() {
        return (Integer)this.field_70180_af.func_187225_a(MAX_LEVEL);
    }

    public void setMaxLevel(int maxLevel) {
        this.field_70180_af.func_187227_b(MAX_LEVEL, (Object)Math.max(maxLevel, 1));
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.isGolden()) {
            return LOOT_GOLDEN;
        }
        return LOOT;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == ModItems.foulCandy;
    }

    class AIPanic
    extends EntityAIPanic {
        public AIPanic(double speed) {
            super((EntityCreature)EntityBookWyrm.this, speed);
        }

        public boolean func_75250_a() {
            return !EntityBookWyrm.this.func_70631_g_() && !EntityBookWyrm.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class AIHurtByTarget
    extends EntityAIHurtByTarget {
        public AIHurtByTarget() {
            super((EntityCreature)EntityBookWyrm.this, true, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (EntityBookWyrm.this.func_70631_g_()) {
                this.func_190105_f();
                this.func_75251_c();
            }
        }

        protected void func_179446_a(EntityCreature creatureIn, EntityLivingBase entityLivingBaseIn) {
            if (creatureIn instanceof EntityBookWyrm && !creatureIn.func_70631_g_()) {
                super.func_179446_a(creatureIn, entityLivingBaseIn);
            }
        }

        public boolean func_75250_a() {
            if (this.field_75299_d.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                return false;
            }
            return super.func_75250_a();
        }
    }
}

